#include "SDL.h"
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define N		1000
#define t(X, Y)		(x+X) + (y+Y) * p
#define lp(h, w)	for (y = 0; y < h; y++) for (x = 0; x < w; x++)


int	x, y, p, *v,
	d = 0, w = 400, h = 300;

int	M[] = {
  0,0,0,0,0, 1,0,1,0,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 0,0,0,0,0,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,0,0,0,0,0, 1,1,1,1,1,0, 1,1,1,1,1, 0,0,0,0,0,
  0,0,0,0,0, 1,0,1,0,1,0, 0,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 0,0,0,0,0,0, 0,0,1,0,0,0, 1,0,0,0,1,0, 0,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,0,0, 1,0,0,0,1,0, 1,0,0,0,1, 0,0,0,0,0,
  1,1,1,0,0, 1,0,1,0,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 0,0,0,0,0,0, 0,0,1,0,0,0, 1,1,1,1,0,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,0,0,0,0,0, 1,1,1,1,1,0, 1,1,1,1,0, 0,0,1,1,1,
  0,0,0,0,0, 1,0,1,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,0,0, 0,0,0,0,0,0, 0,0,1,0,0,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,0,0, 1,0,0,0,0,0, 1,0,0,0,0,0, 1,0,0,0,1, 0,0,0,0,0,
  0,0,0,0,0, 1,1,1,1,0,0, 1,1,1,1,1,0, 1,1,1,1,0,0, 1,1,1,1,1,0, 0,0,0,0,0,0, 0,0,1,0,0,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,1,1,1,0,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,0,0,0,1, 0,0,0,0,0 
};
  /*
  1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,1,
  1,0,0,0,0,0, 1,0,0,0,1,0, 0,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,1,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 0,0,1,0,0,
  1,0,0,0,0,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,1,1,1,0,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,0,1,0,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 0,0,1,0,0,
  1,0,0,0,0,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 1,0,0,0,1,0, 0,0,0,0,1,0, 1,0,0,0,0,0, 1,0,1,0,1,0, 1,0,0,0,0,0, 1,0,0,0,1,0, 0,0,1,0,0,
  1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 1,1,1,1,1,0, 1,1,1,1,1,0, 1,0,1,0,1,0, 1,1,1,1,1,0, 1,0,0,0,1,0, 0,0,1,0,0
};
  */

float	A[N], l = 9e-3, R = 1e-1, D = 4e-2;
float	pi2 = 6.283185, pia = 1.570793 / N;

void	init()
{
  int	i;
  float	a, b, a1, a2, d0;

  for (i = 0; i < N; i++)
    {
      a = R * cos(i * pia);
      b = R * sin(i * pia);
      a1 = a - D;
      a2 = a + D;
      d0 = sqrt(a1 * a1 + b * b) - sqrt(a2 * a2 + b * b);

      A[i] = 1.0 + cos((pi2 * d0) / l);
    }
}

void	show(float theta, float phi, float C)
{
  int	i;
  float	T, P, D = C * R / w;

  lp(h, w)
    {
      T = theta + (h / 2 - y) * D;
      P = phi + (x - w / 2) * D;
      i = (int) (acos(cos(P) * cos(T)) / pia);
      v[t(0,0)] = 128 * A[i];
      v[t(0,0)] <<= 8;
      v[t(0,0)] += 128 * A[(x + i) % N];
      v[t(0,0)] <<= 8;
      v[t(0,0)] += 128 * A[(y + i) % N];
    }
}

void	load()
{
  lp(14, 104)
    v[t(148,143)] = 0xffffff;
  
  lp(12, 102)
    v[t(149,144)] = 0;
  
  lp(10, d)
    v[t(150,145)] = 0xaaaaaa;

  lp(5, 87)
    v[t(156,134)] = 0xffffff * M[y * 87 + x];
}

int	main(int c, char **a)
{
  float		i;
  Uint32	now;
  SDL_Event	e;
  SDL_Surface	*b, *bb;

  b = SDL_SetVideoMode(w, h, 32, 0);
  bb = SDL_CreateRGBSurface(SDL_SRCALPHA, w, h, 32,
			    0x00ff0000, 0x0000ff00,
			    0x000000ff, 0xff000000);

  v = b->pixels;
  p = b->pitch / 4;

  SDL_ShowCursor(0);
  SDL_EventState(4, 0);

  SDL_FillRect(b, 0, 0);
  SDL_FillRect(bb, 0, 0);

  init();      
  now = SDL_GetTicks();

  for(i = 0.0; !SDL_PollEvent(&e) || e.type != 2; i += 1e-2)
    {
      if (d < 101)
	{
	  load();
	  if ((SDL_GetTicks() - now) >= 100) d += 2;
	}
      else if ((d > 100) && (d < 355))
	{
	  if ((SDL_GetTicks() - now) >= 50) d += 5;
	  SDL_FillRect(bb, 0, (d - 100) << 24);
	  SDL_BlitSurface(bb, 0, b, 0);
	}
      else if ((d > 354) && (d < 610))
	{
	  i = 0.0;
	  show(cos(i * sin(i)), sin(i * cos(i)), 30.0 * (1 + cos(i)) + 5.0);
	  if ((SDL_GetTicks() - now) >= 50) d += 5;
	  SDL_FillRect(bb, 0, (610 - d) << 24);
	  SDL_BlitSurface(bb, 0, b, 0);
	}
      else
	{
	  SDL_LockSurface(b);
	  show(cos(i * sin(i)), sin(i * cos(i)), 30.0 * (1 + cos(i)) + 5.0);
	  SDL_UnlockSurface(b);
	}

      SDL_Flip(b);
    }

  return 0;
}
